/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.rental.util;

import itx.erp.ErpObjectContainer;
import itx.erp.sales.conf.SalesSettings;
import itx.erp.sales.model.Article;
import itx.erp.sales.service.ArticleService;
import java.sql.SQLException;
import java.util.Date;
import jtbcore.exception.ContainerException;
import jtbcore.exception.InvalidStateException;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;

public class RentalPriceCalculator {
    protected Article article;
    protected Date startDate;
    protected Date endDate;
    protected SalesSettings salesSettings = (SalesSettings)ErpObjectContainer.getInstance().getBean("salesSettings");

    public void setArticle(Article a) {
        this.article = a;
    }

    public void setStartDate(Date d) {
        this.startDate = d;
    }

    public void setEndDate(Date d) {
        this.endDate = d;
    }

    public Double calcFixed() throws SQLException {
        if ("excl_vat".equals(this.salesSettings.getInputPrice())) {
            return this.article.getPriceExclVat();
        }
        if ("incl_vat".equals(this.salesSettings.getInputPrice())) {
            return this.article.getPriceInclVat();
        }
        return null;
    }

    public Double calcHour() throws SQLException {
        int m = DateUtil.minsBetween(this.startDate, this.endDate);
        Double durationHours = (double)m / 60.0;
        if ("excl_vat".equals(this.salesSettings.getInputPrice())) {
            return this.article.getPriceExclVat() * durationHours;
        }
        if ("incl_vat".equals(this.salesSettings.getInputPrice())) {
            return this.article.getPriceInclVat() * durationHours;
        }
        return null;
    }

    public Double calcWeek() throws SQLException {
        Double p = 0.0;
        Double weekPrice = null;
        if ("excl_vat".equals(this.salesSettings.getInputPrice())) {
            weekPrice = this.article.getPriceExclVat();
        }
        if ("incl_vat".equals(this.salesSettings.getInputPrice())) {
            weekPrice = this.article.getPriceInclVat();
        }
        int ymd2 = DateUtil.date2ymd(this.endDate);
        Date d = this.startDate;
        int counter = 0;
        do {
            int daysBetween;
            Date endPeriod;
            int ymdEndPeriod;
            if ((ymdEndPeriod = DateUtil.date2ymd(endPeriod = DateUtil.nextDay(d, 6)).intValue()) > ymd2) {
                endPeriod = this.endDate;
            }
            p = (daysBetween = DateUtil.daysBetween(d, endPeriod)) == 6 ? Double.valueOf(p + weekPrice) : Double.valueOf(p + weekPrice / 7.0 * (double)(daysBetween + 1));
        } while (DateUtil.date2ymd(d = DateUtil.nextDay(d, 7)) <= ymd2 && counter++ < 10000);
        return NumberUtil.roundPrice(p);
    }

    public Double calculate() throws ContainerException, SQLException, InvalidStateException {
        ArticleService aservice = (ArticleService)ErpObjectContainer.getInstance().getBean("articleService");
        if (!"incl_vat".equals(this.salesSettings.getInputPrice()) && !"excl_vat".equals(this.salesSettings.getInputPrice())) {
            throw new InvalidStateException("Input price method not set");
        }
        if ("fixed".equals(this.article.getPricingMethod())) {
            return this.calcFixed();
        }
        if ("hour".equals(this.article.getPricingMethod())) {
            return this.calcHour();
        }
        if ("week".equals(this.article.getPricingMethod())) {
            return this.calcWeek();
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            ArticleService articleService = (ArticleService)ErpObjectContainer.getInstance().getBean("articleService");
            Article a = articleService.readArticle(6);
            RentalPriceCalculator c = new RentalPriceCalculator();
            c.setStartDate(DateUtil.string2date("2025-06-30"));
            c.setEndDate(DateUtil.string2date("2025-07-13"));
            c.setArticle(a);
            System.out.println("calcweek: " + String.valueOf(c.calcWeek()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

